import processing.video.*;
import processing.pdf.*;
import org.seltar.Bytes2Web.*;
import processing.video.*;
import controlP5.*;

/*******   Declaraciones   *****/

//Usuario
String usuario = "";
String claveusr = "";
boolean validado = false;
String id_timelap_usr = "";

//video
Capture camvideo;
PImage Imgcaptura, Imgprevia, Imglogo, Imglogo2;
PGraphics pg;

boolean acoplamiento = false;
int consecutivo = 200;
int alfavideo = 120;

int xres = 640;
int yres = 480;

String url = "http://www.timelapme.com/Upload.php";

//generador timelap
MovieMaker pelc;
int keyFrmeRate = 25;

String rangoini, rangofin;

//mensajes
PFont fontA;
String mensajes = "";

//MENUS CONTROLP5
ControlP5 controlP5;
MultiList l;
Textfield txtusr, txtclave;
Button btnAcceder, btnGenera;
Slider numfrmes;

//flujo
float optMM = 0;

void setup()
{
   /*********** Configuración principal ***********/
  size( xres, yres);
  frameRate(30);
  
  Imglogo = loadImage("logoch.png");
  
  /************* Configuración del video *****************/
  camvideo = new Capture(this, xres, yres, 25);

  /************* Configuración de mensajes *****************/
   fontA = loadFont("ArialMT-10.vlw");
   textFont(fontA, 10);

  /*********** Configuración del menú ***********/
  controlP5 = new ControlP5(this);
  
  l = controlP5.addMultiList("myList", 20, 20, 100, 12);
  
  MultiListButton b;
  b = l.add("Connect", 1);

  b.add("Login", 11).setLabel("Login");
  b.add("Website", 12).setLabel("Website");

  b = l.add("Timelap", 2);

  b.add("Capture", 21).setLabel("Capture");
  b.add("Generate", 22).setLabel("Generate");

//  b = l.add("Parameters", 3);
  b = l.add("About", 4);
  
  b = l.add("Exit", 5);

  /************  Configuración de video  ***************/
  rangoini = "1900-01-01";
  rangofin = "2050-01-01";
  
  numfrmes = controlP5.addSlider("frmerate", 1, 25, 1, (xres - 305)/2, (yres - 65)/2, 200, 14);
  numfrmes.setNumberOfTickMarks(25);
  numfrmes.setSliderMode(Slider.FLEXIBLE);
  numfrmes.hide();

  btnGenera = controlP5.addButton("Generate video", 0, (xres - 305)/2 + 255, (yres - 65)/2, 50, 20);
  btnGenera.hide();
  
  /************  usuario     ***************/
  txtusr = controlP5.addTextfield("User", (xres - 100)/2, (yres - 65)/2, 100, 20);  
  txtusr.hide();
  
  txtclave = controlP5.addTextfield("password", (xres - 100)/2,(yres - 65)/2 + 34, 100, 20);  
  txtclave.setPasswordMode(true);
  txtclave.hide();
  
  btnAcceder = controlP5.addButton("login", 0, (xres - 160)/2 + 135, (yres - 65)/2, 50, 20);
  btnAcceder.hide();
}

void controlEvent(ControlEvent theEvent) 
{
  if (theEvent.controller().name() == "myList")
  {
    alfavideo = 120;
    optMM = theEvent.value();
    if (id_timelap_usr == "")
    {
      if ((theEvent.value() == 21) || (theEvent.value() == 22))
      {
        optMM = 0;    
        mensajes = "You need to login first";
      }  
    }
    
    if (optMM == 12)
    {
      link("http://www.timelapme.com/login.php");
      mensajes = usuario + ": Acceso a www.timelapme.com";
    }
    else if (optMM == 21)
    {
      alfavideo = 255;
      String lines[] = loadStrings("http://www.timelapme.com/consecutivo.php?usr=" + id_timelap_usr);
  
      if (lines.length > 0)
      {
        if (Integer.parseInt(lines[0]) == 0)
        {
          mensajes = usuario + ": this is your first capture";
        }
        else
        {
          mensajes = usuario + ": Previous image correctly loaded";
          
          Imgprevia = loadImage("http://www.timelapme.com/images/content/" + lines[0] + ".jpg");
          acoplamiento = true;
        }
      }
      else
      {
        mensajes = usuario + ": There was a problem while loading the previous image";
      }
    }
    else if(optMM == 22)
    {
      numfrmes.show();
      btnGenera.show();
  
      mensajes = usuario + ": please define the frames per second rate";      
    }
    if (optMM == 4)
    {
      Imglogo2 = loadImage("tabout.png");
    }
    if (optMM == 5)
    {  
      exit();
    }    
  }
}


void draw()
{
  background(255);
    
  //Sección mensajes
  fill(40);
  rect(0, 430, 640, 50);
  fill(255);
  text(mensajes, 20, 450);

  //muestra capture
  tint(255, alfavideo);
  image(camvideo, 0, 0);

  //logo
  image(Imglogo, 560, 17);

  if (optMM == 11)
  {
    txtusr.show();
    txtclave.show();
    btnAcceder.show();
  }
  if (optMM == 21)
  {
    if (acoplamiento)
    {
      tint(255, 100);
      image(Imgprevia, 0, 0);
    }
  }
  else if (optMM == 22)
  {
    //muestra generate video
  }
  else if (optMM == 3)
  {
    //muestra login
  }
  else if (optMM == 4)
  {
    fill(40);
    rect(220, 120, 200, 240);
    //logo
    image(Imglogo2, 240, 140);
  }
}

void captureEvent(Capture camvideo)
{
  camvideo.read();
}

public void generar(int theValue)
{
  //genera video
  String filename = "videos/" + usuario + ".mov";
  pelc = new MovieMaker(this, xres, yres, filename, 24, MovieMaker.SORENSON, MovieMaker.HIGH, keyFrmeRate);

  String lines[] = loadStrings("http://www.timelapme.com/rangoimgs.php?usr=" + id_timelap_usr);
  print(lines.length);
    print(lines[0]);

  for (int i = 0; i < lines.length; i++)
  {
    print(lines[i]);
    Imgprevia = loadImage("http://www.timelapme.com/images/content/" + lines[i]);    
    Imgprevia.loadPixels();
    pelc.addFrame(Imgprevia.pixels, Imgprevia.width, Imgprevia.height);
  }
  pelc.finish();

  numfrmes.hide();
  btnGenera.hide();
  optMM = 0;
  mensajes = "Generated video: /videos/" + usuario + ".mov";
}

public void acceder(int theValue)
{
  usuario = txtusr.getText();
  claveusr = txtclave.getText();

  //valida usuario capturado
  String lines[] = loadStrings("http://www.timelapme.com/validacion.php?usr=" + usuario + "&&clave=" + claveusr);
  if (lines.length > 0)
  {
    println(lines[0]);
    mensajes = "Login problems, please check your account";
    if (Integer.parseInt(lines[0]) != 0)
    {
      id_timelap_usr = lines[0];
      mensajes = usuario + ": succesfully connected!";
    }
    else
    {
      mensajes = "Problems with the user, password or internet access";      
    }
    txtusr.hide();
    txtclave.hide();
    btnAcceder.hide();
    optMM = 0;
  }
}

String validando()
{
  //valida usuario capturado
  String lines[] = loadStrings("http://www.timelapme.com/validacion.php?usr=" + usuario + "&&clave=" + claveusr);
  if (lines.length > 0)
  {
    return lines[0];
  }
  return "0";
}

void keyPressed()
{
  String url = "http://www.timelapme.com/Upload.php";
  if ((key == ' ') && (optMM == 21))
  {
    Imgcaptura = camvideo;
    consecutivo++;
    PGraphics pg = createGraphics(xres, yres, P2D);
    pg.beginDraw();
    pg.image(camvideo, 0, 0);
    pg.endDraw();
    
    String lines[] = loadStrings("http://www.timelapme.com/guardaimg.php?usr=" + id_timelap_usr);
    if (lines.length > 0)
    {
      ImageToWeb img = new ImageToWeb(this);
      img.setType(ImageToWeb.JPEG);
      img.post("content", url, lines[0], false, img.getBytes(pg));
      mensajes = usuario + ": Image succesfully saved, now you can add any comment for it on the website";
    }
    else
    {
      mensajes = usuario + ": There were problems while saving the image on the server";
    }
    optMM = 0;
    alfavideo = 120;
  }
}

void frmerate(int theColor)
{
  keyFrmeRate = theColor;
}

