/*
 * Decompiled with CFR 0.152.
 */
package org.seltar.Bytes2Web;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.seltar.Bytes2Web.PostToWeb;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class ImageToWeb
extends PostToWeb {
    String imageType;
    public int type;
    public static final int JPEG = 0;
    public static final int PNG = 1;
    public static final int GIF = 2;
    public static final int TIFF = 3;
    static byte[] TIFF_HEADER;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 77;
        byArray[1] = 77;
        byArray[3] = 42;
        byArray[7] = 8;
        byArray[9] = 9;
        byArray[11] = -2;
        byArray[13] = 4;
        byArray[17] = 1;
        byArray[22] = 1;
        byArray[25] = 3;
        byArray[29] = 1;
        byArray[34] = 1;
        byArray[35] = 1;
        byArray[37] = 3;
        byArray[41] = 1;
        byArray[46] = 1;
        byArray[47] = 2;
        byArray[49] = 3;
        byArray[53] = 3;
        byArray[57] = 122;
        byArray[58] = 1;
        byArray[59] = 6;
        byArray[61] = 3;
        byArray[65] = 1;
        byArray[67] = 2;
        byArray[70] = 1;
        byArray[71] = 17;
        byArray[73] = 4;
        byArray[77] = 1;
        byArray[80] = 3;
        byArray[82] = 1;
        byArray[83] = 21;
        byArray[85] = 3;
        byArray[89] = 1;
        byArray[91] = 3;
        byArray[94] = 1;
        byArray[95] = 22;
        byArray[97] = 3;
        byArray[101] = 1;
        byArray[106] = 1;
        byArray[107] = 23;
        byArray[109] = 4;
        byArray[113] = 1;
        byArray[123] = 8;
        byArray[125] = 8;
        byArray[127] = 8;
        TIFF_HEADER = byArray;
    }

    public ImageToWeb(PApplet pApplet) {
        super(pApplet);
        this.setType(0);
    }

    public void setType(int n) {
        switch (n) {
            case 0: {
                this.type = 0;
                this.cType = "image/jpeg";
                this.imageType = "jpg";
                break;
            }
            case 1: {
                this.type = 1;
                this.cType = "image/png";
                this.imageType = "png";
                break;
            }
            case 2: {
                this.type = 2;
                this.cType = "image/gif";
                this.imageType = "gif";
                break;
            }
            case 3: {
                this.type = 3;
                this.cType = "image/tiff";
                this.imageType = "tiff";
                break;
            }
            default: {
                ImageToWeb.println((String)"Unknown type");
                return;
            }
        }
    }

    public void post(String string, String string2, String string3, boolean bl) {
        super._post(string, string2, String.valueOf(string3) + "." + this.imageType, bl);
    }

    public void post(String string, String string2, String string3, boolean bl, byte[] byArray) {
        super._post(string, string2, String.valueOf(string3) + "." + this.imageType, bl, byArray);
    }

    public void save(String string, boolean bl) {
        super._save(string, this.imageType, bl);
    }

    public void save(String string) {
        super._save(string);
    }

    public void save(String string, byte[] byArray) {
        super._save(string, byArray);
    }

    public byte[] getBytes() {
        return this.getBytes(this.papplet.g);
    }

    public byte[] getBytes(PGraphics pGraphics) {
        switch (this.type) {
            case 0: {
                BufferedImage bufferedImage = new BufferedImage(pGraphics.width, pGraphics.height, 1);
                pGraphics.loadPixels();
                bufferedImage.setRGB(0, 0, pGraphics.width, pGraphics.height, pGraphics.pixels, 0, pGraphics.width);
                return this.getBytesJPEG(bufferedImage);
            }
            case 1: 
            case 2: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)((BufferedImage)pGraphics.image), this.imageType, byteArrayOutputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return new byte[0];
                }
                return byteArrayOutputStream.toByteArray();
            }
            case 3: {
                return this.getBytesTIFF((PImage)pGraphics);
            }
        }
        ImageToWeb.println((String)"Unknown type");
        return new byte[0];
    }

    protected byte[] getBytesJPEG(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
        if (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(1.0f);
            MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
            imageWriter.setOutput(memoryCacheImageOutputStream);
            try {
                imageWriter.write(bufferedImage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new byte[0];
            }
            return byteArrayOutputStream.toByteArray();
        }
        return new byte[0];
    }

    protected byte[] getBytesTIFF(PImage pImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[768];
            System.arraycopy(TIFF_HEADER, 0, byArray, 0, TIFF_HEADER.length);
            byArray[30] = (byte)(pImage.width >> 8 & 0xFF);
            byArray[31] = (byte)(pImage.width & 0xFF);
            byArray[42] = byArray[102] = (byte)(pImage.height >> 8 & 0xFF);
            byArray[43] = byArray[103] = (byte)(pImage.height & 0xFF);
            int n = pImage.width * pImage.height * 3;
            byArray[114] = (byte)(n >> 24 & 0xFF);
            byArray[115] = (byte)(n >> 16 & 0xFF);
            byArray[116] = (byte)(n >> 8 & 0xFF);
            byArray[117] = (byte)(n & 0xFF);
            byteArrayOutputStream.write(byArray);
            pImage.loadPixels();
            int n2 = 0;
            while (n2 < pImage.pixels.length) {
                byteArrayOutputStream.write(pImage.pixels[n2] >> 16 & 0xFF);
                byteArrayOutputStream.write(pImage.pixels[n2] >> 8 & 0xFF);
                byteArrayOutputStream.write(pImage.pixels[n2] & 0xFF);
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

