/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Slider2D
extends Controller {
    protected int cWidth = 10;
    protected int cHeight = 10;
    protected float cX;
    protected float cY;
    protected float _myMinX;
    protected float _myMinY;
    protected float _myMaxX;
    protected float _myMaxY;
    protected boolean isCrosshairs;

    protected Slider2D(ControlP5 controlP5, ControllerGroup controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myArrayValue = new float[]{0.0f, 0.0f};
        this._myMinX = 0.0f;
        this._myMinY = 0.0f;
        this._myMaxX = n3;
        this._myMaxY = n4;
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isInside() && !ControlP5.keyHandler.isAltDown) {
            float f = PApplet.constrain((float)((float)pApplet.mouseX - this.position.x()), (float)0.0f, (float)(this.width - this.cWidth));
            float f2 = PApplet.constrain((float)((float)pApplet.mouseY - this.position.y()), (float)0.0f, (float)(this.height - this.cHeight));
            if (this.isMousePressed) {
                this.cX = f;
                this.cY = f2;
                this.updateValue();
            }
        }
    }

    protected void updateValue() {
        this.setValue(0.0f);
    }

    public void setMinX(float f) {
        this._myMinX = f;
        this.updateValue();
    }

    public void setMinY(float f) {
        this._myMinY = f;
        this.updateValue();
    }

    public void setMaxX(float f) {
        this._myMaxX = f;
        this.updateValue();
    }

    public void setMaxY(float f) {
        this._myMaxY = f;
        this.updateValue();
    }

    public float getMinX() {
        return this._myMinX;
    }

    public float getMinY() {
        return this._myMinY;
    }

    public float getMaxX() {
        return this._myMaxX;
    }

    public float getMaxY() {
        return this._myMaxY;
    }

    public void setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
        float f = (float)(this.width - this.cWidth) / (this._myMaxX - this._myMinX);
        float f2 = (float)(this.height - this.cHeight) / (this._myMaxY - this._myMinY);
        this.cX = PApplet.constrain((float)(fArray[0] * f), (float)0.0f, (float)(this.width - this.cWidth));
        this.cY = PApplet.constrain((float)(fArray[1] * f2), (float)0.0f, (float)(this.height - this.cHeight));
        this.updateValue();
    }

    public void setValue(float f) {
        this._myArrayValue[0] = this.cX / ((float)(this.width - this.cWidth) / (float)this.width);
        this._myArrayValue[1] = this.cY / ((float)(this.height - this.cHeight) / (float)this.height);
        this._myArrayValue[0] = PApplet.map((float)this._myArrayValue[0], (float)0.0f, (float)this.width, (float)this._myMinX, (float)this._myMaxX);
        this._myArrayValue[1] = PApplet.map((float)this._myArrayValue[1], (float)0.0f, (float)this.height, (float)this._myMinY, (float)this._myMaxY);
        this._myValueLabel.set(this.adjustValue(this._myArrayValue[0], 0) + "," + this.adjustValue(this._myArrayValue[1], 0));
        this.broadcast(1);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        ControlP5.logger().info("saving Slider2D is not implemented yet.");
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new Slider2DDisplay();
                break;
            }
        }
    }

    class Slider2DDisplay
    implements ControllerDisplay {
        Slider2DDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.pushStyle();
            if (controller.isInside()) {
                pApplet.fill(controller.color().colorForeground);
            } else {
                pApplet.fill(controller.color().colorBackground);
            }
            pApplet.rect(0.0f, 0.0f, (float)Slider2D.this.width, (float)Slider2D.this.height);
            if (Slider2D.this.isCrosshairs) {
                if (controller.isInside()) {
                    pApplet.stroke(controller.color().colorBackground);
                } else {
                    pApplet.stroke(controller.color().colorForeground);
                }
                pApplet.line(0.0f, Slider2D.this.cY, (float)Slider2D.this.width, Slider2D.this.cY);
                pApplet.line(Slider2D.this.cX, 0.0f, Slider2D.this.cX, (float)Slider2D.this.height);
                pApplet.noStroke();
            }
            pApplet.fill(controller.color().colorActive);
            pApplet.rect(Slider2D.this.cX, Slider2D.this.cY, (float)Slider2D.this.cWidth, (float)Slider2D.this.cHeight);
            pApplet.popStyle();
            Slider2D.this._myCaptionLabel.draw(pApplet, 0, Slider2D.this.height + 4);
            Slider2D.this._myValueLabel.draw(pApplet, Slider2D.this._myCaptionLabel.width() + 4, Slider2D.this.height + 4);
        }
    }
}

