/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFontRenderer;
import controlP5.CDrawable;
import controlP5.CVector3f;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControllerStyle;
import java.awt.Component;
import processing.core.PApplet;
import processing.core.PImage;

public class Label
implements CDrawable {
    protected PImage _myImage;
    protected PImage _myImageMask;
    protected String _myText;
    protected int _myWidth;
    protected int _myHeight;
    protected int _myColor;
    public boolean isToUpperCase = true;
    protected boolean isFixedSize = false;
    public static BitFontRenderer bitFontRenderer;
    protected int _myFontIndex = 0;
    protected int _myCursorPosition = -1;
    protected boolean isMultiline = false;
    protected int _myLineHeight = 10;
    protected int _myOffsetY = 0;
    protected int textHeight;
    protected boolean isVisible = true;
    public CVector3f position = new CVector3f();
    protected int _myLetterSpacing = 0;
    protected int _myColorBackground = 0;
    protected boolean isColorBackground = false;
    public static int LABEL_WIDTH_OFFSET;
    public ControllerStyle _myControllerStyle = new ControllerStyle();
    protected int _myOffsetX = 0;
    protected boolean isControlFont = false;
    protected ControlFont _myControlFont;
    protected int _myControlFontSize;

    protected Label(String string) {
        this(string, 0, 10, -1);
    }

    protected Label(String string, int n) {
        this(string, 0, 10, n);
    }

    protected Label(String string, int n, int n2) {
        this(string, n, n2, -1);
    }

    protected Label(String string, int n, int n2, int n3) {
        bitFontRenderer = new BitFontRenderer();
        this.init(string, n != 0 ? n : bitFontRenderer.getWidth(string, this), n2, n3);
    }

    public Label(PApplet pApplet, String string, int n, int n2, int n3) {
        bitFontRenderer = new BitFontRenderer((Component)pApplet);
        this.init(string, n, n2, n3);
    }

    public Label(PApplet pApplet, String string, int n, int n2) {
        this(pApplet, string, n, n2, 0xFFFFFF);
    }

    private void init(String string, int n, int n2, int n3) {
        this._myText = string == null ? "" : string;
        this._myWidth = n + LABEL_WIDTH_OFFSET;
        this._myHeight = n2;
        this._myColor = n3;
        this.isControlFont = ControlP5.isControlFont;
        if (this.isControlFont && ControlP5.getControlFont() != null) {
            this.setControlFont(ControlP5.getControlFont());
        }
        this._myImage = new PImage(this._myWidth, this._myHeight);
        this._myImageMask = new PImage(this._myWidth, this._myHeight);
        this.setFixedSize(true);
        this.set(this._myText);
    }

    private void checkRenderer() {
    }

    public void toUpperCase(boolean bl) {
        this.isToUpperCase = bl;
        this.update();
    }

    public void draw(PApplet pApplet, int n, int n2) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
            if (this.isColorBackground) {
                pApplet.fill(this._myColorBackground);
                float f = this._myControllerStyle.paddingRight + this._myControllerStyle.paddingLeft;
                f = this._myControllerStyle.backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myImage.width);
                float f2 = this._myControllerStyle.paddingBottom + this._myControllerStyle.paddingTop;
                f2 = this._myControllerStyle.backgroundHeight > -1 ? (f2 += (float)this._myControllerStyle.backgroundHeight) : (f2 += (float)this._myImage.height);
                pApplet.rect((float)n, (float)n2, f, f2);
            }
            if (this.isControlFont) {
                this.renderControlFont(pApplet, n + this._myControllerStyle.paddingLeft, n2 + this._myControllerStyle.paddingTop);
            } else if (this._myImage.width > 0 && this._myImage.height > 0 || !this.isControlFont) {
                pApplet.image(this._myImage, (float)(n + this._myControllerStyle.paddingLeft), (float)(n2 + this._myControllerStyle.paddingTop));
            }
            pApplet.popMatrix();
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isVisible) {
            pApplet.pushMatrix();
            pApplet.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
            if (this.isColorBackground) {
                pApplet.fill(this._myColorBackground);
                float f = this._myControllerStyle.paddingRight + this._myControllerStyle.paddingLeft;
                f = this._myControllerStyle.backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myImage.width);
                float f2 = this._myControllerStyle.paddingBottom + this._myControllerStyle.paddingTop;
                f2 = this._myControllerStyle.backgroundHeight > -1 ? (f2 += (float)this._myControllerStyle.backgroundHeight) : (f2 += (float)this._myImage.height);
                pApplet.rect(this.position.x, this.position.y, f, f2);
            }
            if (this.isControlFont) {
                this.renderControlFont(pApplet, this.position.x + (float)this._myControllerStyle.paddingLeft, this.position.y + (float)this._myControllerStyle.paddingTop);
            } else {
                pApplet.image(this._myImage, this.position.x + (float)this._myControllerStyle.paddingLeft, this.position.y + (float)this._myControllerStyle.paddingTop);
            }
            pApplet.popMatrix();
        }
    }

    protected void draw(PApplet pApplet, int n, int n2, int n3) {
        pApplet.pushMatrix();
        pApplet.translate((float)this._myControllerStyle.marginLeft, (float)this._myControllerStyle.marginTop);
        this._myColor = n3;
        if (this.isControlFont) {
            if (this.isColorBackground) {
                pApplet.fill(this._myColorBackground);
                float f = this._myControllerStyle.paddingRight + this._myControllerStyle.paddingLeft;
                f = this._myControllerStyle.backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myImage.width);
                float f2 = this._myControllerStyle.paddingBottom + this._myControllerStyle.paddingTop;
                f2 = this._myControllerStyle.backgroundHeight > -1 ? (f2 += (float)this._myControllerStyle.backgroundHeight) : (f2 += (float)this._myImage.height);
                pApplet.rect((float)n, (float)n2, f, f2);
            }
            this.renderControlFont(pApplet, n + this._myControllerStyle.paddingLeft, n2 + this._myControllerStyle.paddingTop);
        } else if (this._myImage.width > 0 && this._myImage.height > 0) {
            if (this.isColorBackground) {
                pApplet.fill(this._myColorBackground);
                float f = this._myControllerStyle.paddingRight + this._myControllerStyle.paddingLeft;
                f = this._myControllerStyle.backgroundWidth > -1 ? (f += (float)this._myControllerStyle.backgroundWidth) : (f += (float)this._myImage.width);
                float f3 = this._myControllerStyle.paddingBottom + this._myControllerStyle.paddingTop;
                f3 = this._myControllerStyle.backgroundHeight > -1 ? (f3 += (float)this._myControllerStyle.backgroundHeight) : (f3 += (float)this._myImage.height);
                pApplet.rect((float)n, (float)n2, f, f3);
            }
            pApplet.image(this._myImage, (float)(n + this._myControllerStyle.paddingLeft), (float)(n2 + this._myControllerStyle.paddingTop));
        }
        pApplet.popMatrix();
    }

    protected void renderControlFont(PApplet pApplet, float f, float f2) {
        pApplet.fill(this._myColor);
        pApplet.textFont(this._myControlFont.getPFont(), (float)this._myControlFontSize);
        pApplet.textLeading((float)this._myLineHeight);
        pApplet.translate(0.0f, this._myControlFont.getPFont().getFont().getSize2D() * 0.7f);
        pApplet.text(this.isToUpperCase ? this._myText.toUpperCase() : this._myText, f, f2);
    }

    public void set(String string) {
        boolean bl = this.isFixedSize;
        this.setFixedSize(false);
        this.set(string, this._myColor, this._myCursorPosition);
        this.setFixedSize(bl);
    }

    public void set(String string, int n) {
        boolean bl = this.isFixedSize;
        this.setFixedSize(false);
        this._myColor = n;
        this.set(string, this._myColor, this._myCursorPosition);
        this.setFixedSize(bl);
    }

    public void set(String string, boolean bl) {
        this.setFixedSize(bl);
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void set(String string, int n, boolean bl) {
        this._myColor = n;
        this.setFixedSize(bl);
        this.set(string, this._myColor, this._myCursorPosition);
    }

    public void setWithCursorPosition(String string, int n) {
        this._myOffsetX = 0;
        this.set(string, this._myColor, n, this._myOffsetX);
    }

    public void setWithCursorPosition(String string, int n, int n2) {
        this._myOffsetX = n2;
        this.set(string, this._myColor, n, this._myOffsetX);
    }

    public Label setFont(int n) {
        this.isControlFont = false;
        this._myFontIndex = n;
        this.update();
        return this;
    }

    public int getFont() {
        return this._myFontIndex;
    }

    public ControlFont setControlFont(ControlFont controlFont) {
        this._myControlFont = controlFont;
        this.setControlFontSize(this._myControlFont.size());
        this.isControlFont = true;
        return this._myControlFont;
    }

    protected void updateFont(ControlFont controlFont) {
        this.setControlFont(controlFont);
    }

    public ControlFont getControlFont() {
        return this._myControlFont;
    }

    public void setControlFontSize(int n) {
        this._myControlFontSize = n;
        this.update();
    }

    public Label adjust() {
        if (this.isControlFont) {
            this._myHeight = BitFontRenderer.font[this._myFontIndex].height;
            this._myWidth = bitFontRenderer.getWidth(this);
            this._myWidth += this._myText.length() * this._myLetterSpacing;
        }
        this.update();
        return this;
    }

    protected int getFontIndex() {
        return this._myFontIndex;
    }

    protected void setLineHeight(int n) {
        this._myLineHeight = n;
        this.update();
    }

    protected void setLetterSpacing(int n) {
        this._myLetterSpacing = n;
        this.update();
    }

    public void multiline(boolean bl) {
        this.isMultiline = bl;
    }

    protected void update() {
        if (this.isControlFont) {
            ControlP5.papplet.textFont(this._myControlFont.getPFont(), (float)this._myControlFontSize);
            this._myWidth = (int)ControlP5.papplet.textWidth(this.isToUpperCase ? this._myText.toUpperCase() : this._myText);
        } else {
            if (!this.isFixedSize) {
                this._myHeight = BitFontRenderer.font[this._myFontIndex].height;
                this._myWidth = bitFontRenderer.getWidth(this);
                this._myWidth += this._myText.length() * this._myLetterSpacing;
            }
            this._myImage = new PImage(this._myWidth, this._myHeight);
            this._myImageMask = new PImage(this._myWidth, this._myHeight);
            this.set(this._myText, this._myColor, this._myCursorPosition);
        }
    }

    public void setOffset(float f) {
        this._myOffsetY = (int)f;
    }

    public int offset() {
        return this._myOffsetY;
    }

    protected void set(String string, int n, int n2) {
        this._myOffsetX = 0;
        this.set(string, n, n2, this._myOffsetX);
    }

    protected void set(String string, int n, int n2, int n3) {
        this._myOffsetX = n3;
        this._myCursorPosition = n2;
        if (string == null) {
            string = "";
        }
        this._myText = string;
        if (!this.isControlFont) {
            int n4;
            if (!this.isFixedSize && (n4 = bitFontRenderer.getWidth(this)) > this._myWidth) {
                this._myWidth = n4;
                this._myImage = new PImage(n4, this._myHeight);
                this._myImageMask = new PImage(this._myWidth, this._myHeight);
            }
            this._myColor = n;
            this.textHeight = bitFontRenderer.write(this);
            this._myImage.updatePixels();
        }
    }

    protected PImage getImage() {
        return this._myImage;
    }

    protected PImage getImageMask() {
        return this._myImageMask;
    }

    protected int getOffsetX() {
        return this._myOffsetX;
    }

    protected int getOffsetY() {
        return this._myOffsetY;
    }

    protected int getCursorPosition() {
        return this._myCursorPosition;
    }

    protected int getLetterSpacing() {
        return this._myLetterSpacing;
    }

    public int lineHeight() {
        return this._myLineHeight;
    }

    public int getLineHeight() {
        return this._myLineHeight;
    }

    protected boolean isMultiline() {
        return this.isMultiline;
    }

    public int textHeight() {
        return this.textHeight;
    }

    public void fixedSize(boolean bl) {
        this.isFixedSize = bl;
    }

    public void setFixedSize(boolean bl) {
        this.isFixedSize = bl;
    }

    public int color() {
        return this._myColor;
    }

    public int getColor() {
        return this._myColor;
    }

    public void setColor(int n) {
        this._myColor = n;
        this.set(this._myText, n);
    }

    public void setColor(int n, boolean bl) {
        this._myColor = n;
        this.set(this._myText, n, bl);
    }

    public void setColorBackground(int n) {
        this._myColorBackground = n;
        this.isColorBackground = true;
    }

    public void disableColorBackground() {
        this.isColorBackground = false;
    }

    public void enableColorBackground() {
        this.isColorBackground = true;
    }

    public int width() {
        return this._myWidth;
    }

    public int height() {
        return this._myHeight;
    }

    public void setWidth(int n) {
        this._myWidth = n;
    }

    public void setHeight(int n) {
        this._myHeight = n;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public String toString() {
        return this._myText;
    }

    public String getText() {
        return this._myText;
    }

    public ControllerStyle style() {
        return this._myControllerStyle;
    }

    static {
        LABEL_WIDTH_OFFSET = 4;
    }
}

