/*
 * Decompiled with CFR 0.152.
 */
package processing.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import processing.core.PApplet;
import processing.pdf.PGraphicsPDF;

public class BytePGraphicsPDF
extends PGraphicsPDF {
    protected OutputStream outStream;

    protected void allocate() {
        this.outStream = new ByteArrayOutputStream(16384);
    }

    public void beginDraw() {
        if (this.document == null) {
            this.document = new Document(new Rectangle((float)this.width, (float)this.height));
            try {
                this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outStream);
                this.document.open();
                this.content = this.writer.getDirectContent();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Problem writing the PDF data.");
            }
            this.mapper = new DefaultFontMapper();
            if (PApplet.platform == 2) {
                try {
                    String string = String.valueOf(System.getProperty("user.home")) + "/Library/Fonts";
                    this.mapper.insertDirectory(string);
                }
                catch (Exception exception) {}
                this.mapper.insertDirectory("/System/Library/Fonts");
                this.mapper.insertDirectory("/Library/Fonts");
            } else if (PApplet.platform == 1) {
                File[] fileArray = File.listRoots();
                int n = 0;
                while (n < fileArray.length) {
                    if (!fileArray[n].toString().startsWith("A:")) {
                        File file = new File(fileArray[n], "WINDOWS/Fonts");
                        if (file.exists()) {
                            this.mapper.insertDirectory(file.getAbsolutePath());
                            break;
                        }
                        file = new File(fileArray[n], "WINNT/Fonts");
                        if (file.exists()) {
                            this.mapper.insertDirectory(file.getAbsolutePath());
                            break;
                        }
                    }
                    ++n;
                }
            }
            this.g2 = this.content.createGraphics((float)this.width, (float)this.height, (FontMapper)this.mapper);
        }
        super.beginDraw();
    }

    public byte[] getBytes() {
        return ((ByteArrayOutputStream)this.outStream).toByteArray();
    }
}

